﻿<%@ Page Language="C#" MasterPageFile = "~/Registry.master" AutoEventWireup="true" CodeFile="AutoReferralTriage.aspx.cs" Inherits="AutoReferralTriage" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href ="styles/StyleSheet.css"/>
    <link rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.16/themes/base/jquery-ui.css" type="text/css" media="all" />

</asp:Content> 

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <script type = "text/javascript">

        $(document).ready(function() {

            $('.triaging').click(function() {

                var count = 0;
                var countTriaged = 0;

                $.ajax(
                {
                    type: "POST",
                    data: "{}",
                    async: false,
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    url: "ReferralAutoTriage.asmx/ReferralsAutoTriageCount",

                    success: function(response) {
                        //alert("success " + response.d);
                        count = response.d;

                    },
                    failure: function(response) {
                        //alert("failure " + response.d);
                        //need to display failure info and exit 
                        count = 0;
                    }
                });

                if (count === 0) {
                    alert("There are no referrals to triage so auto-triage will not run.");
                    return;

                }
                else {
                    if (!confirm(count + " referral records will be processed. Continue?")) return;
                }

                $("#dialog-triage-accepted").dialog({
                    autoOpen: false,
                    position: [175, 175],
                    draggable: false,
                    height: 140,
                    modal: true
                });

                $("#dialog-triage-accepted").dialog('open');

                $.ajax(
                {
                    type: "POST",
                    data: "{}",
                    dataType: "json",
                    async: false,
                    contentType: "application/json; charset=utf-8",
                    url: "ReferralAutoTriage.asmx/RunTriageReferrals",

                    success: function(response) {
                        countTriaged += parseInt(response.d);               
                        $("#dialog-triage-accepted").dialog('close');
                    },
                    failure: function(response) {
                        //alert(response.d);
                        //need to display failure info and exit 
                    }
                });

                $("#dialog-triage-ineligibles").dialog({
                    autoOpen: false,
                    position: [175, 175],
                    draggable: false,
                    height: 140,
                    modal: true
                })
                .dialog("widget").find(".ui-dialog-titlebar-close").hide();

                $("#dialog-triage-ineligibles").dialog('open');

                $.ajax(
                {
                    type: "POST",
                    data: "{}",
                    async: false,
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    url: "ReferralAutoTriage.asmx/RunTriageIneligibles",

                    success: function(response) {
                        countTriaged += parseInt(response.d);
                        $("#dialog-triage-ineligibles").dialog('close');
                    },
                    failure: function(response) {
                        //alert(response.d);
                        //need to display failure info and exit 
                        //return;
                    }
                });

                $("#dialog-triage-duplicates").dialog({
                    autoOpen: false,
                    position: [175, 175],
                    draggable: false,
                    height: 140,
                    modal: true
                }).dialog("widget").find(".ui-dialog-titlebar-close").hide();

                $("#dialog-triage-duplicates").dialog('open');

                $.ajax(
                {
                    type: "POST",
                    data: "{}",
                    async: false,
                    dataType: "json",
                    contentType: "application/json; charset=utf-8",
                    url: "ReferralAutoTriage.asmx/RunTriageDuplicates",                   
                    success: function(response) {
                        countTriaged += parseInt(response.d);
                        $("#dialog-triage-duplicates").dialog('close');

                    },
                    failure: function(response) {
                        //alert(response.d);
                        //need to display failure info and exit 
                        return;
                    }
                });

                alert('Processing completed. ' + countTriaged + ' records were processed.');

            });
          
        });
            
    </script> 

    <div class="breadcrumb">
        <asp:Label ID = "BreadCrumbLabel" runat="server" Text="Administration > Auto Triage"/>
    </div>  
        
    <br />
        
    <input id = "triagebtn" class = "triaging" value = "Run Auto Triage" type = "button" style = "width:140px" />
    <asp:Button ID = "CloseButton" runat = "server" Text = "Back" OnClick="CloseButton_OnClick" CssClass = "cancel" Width = "140px" /> 

    <div id="dialog-triage-accepted" title="Automatic triage" style = "display:none">
	    <p>Now processing Accepted referrals.</p>
    </div>
    
    <div id="dialog-triage-duplicates" title="Automatic triage" style = "display:none">
	    <p>Now processing Duplicate referrals.</p>
    </div>
    
    <div id="dialog-triage-ineligibles" title="Automatic triage" style = "display:none">
	    <p>Now processing Ineligible referrals.</p>
    </div>
     
    

</asp:Content> 